  @echo off
  setlocal

REM Update the firmware on a SmartCard4 for GC-QQQ (Bronco-Balaur).

REM Input parameters:
REM    %1% = SmartCard4 IP address
REM    %2% = Full path to a log file

REM MODIFICATION HISTORY:
REM 11JUL2008 KK  (Knute Kresie) Derived this from the 5773N\update.bat script used by Mustang
REM           for use by Bronco-Balaur         its the G7000\update4.bat script.

REM Use "~nx" to get the "fname.ext" portion of the full path in %0
  set  ID=%~nx0
  set  RETURN_STATUS=0

  set IP=%1%
  echo %ID%: IP=%IP%
  if {%IP%} NEQ {} goto :IP_OK
  echo %ID%: IP is missing
  goto error_exit

:IP_OK

  set LOGF=%2%
  echo %ID%: LOGF=%LOGF%
  if {%LOGF%} NEQ {} goto :LOGF_OK
  echo %ID%: LOGF is missing
  goto error_exit

:LOGF_OK

REM Use single ">" below to force replacement of previous file content, if any.
REM Use       ">>" below to append to existing file or create new file if needed.

  echo %ID%: IP=%IP%                  >> %LOGF%
  date /t  >> %LOGF%
  time /t  >> %LOGF%

  echo %ID%: ====== Test if IPaddr points to an Agilent SmartCard4 .....
  echo %ID%: ====== Test if IPaddr points to an Agilent SmartCard4 ..... >> %LOGF%

  @echo on
  sc4update.exe %IP%  time
  @echo off
  echo
  echo %ID%: ERRORLEVEL=%ERRORLEVEL%           >> %LOGF%
  if %ERRORLEVEL% NEQ 0 goto error_exit 


:DO_FW_UPDATE

  echo %ID%: ====== Update the firmware .....
  echo %ID%: ====== Update the firmware ..... >> %LOGF%

REM omission of sc4update optional_command (2nd) parameter implies interactive update

  @echo on
  sc4update.exe  %IP%
  @echo off
  echo
  echo %ID%: ERRORLEVEL=%ERRORLEVEL%           >> %LOGF%
  if %ERRORLEVEL% NEQ 0 goto error_exit 


  echo %ID%: Firmware update completed.  >> %LOGF%

  goto done
:error_exit

  set RETURN_STATUS=%ERRORLEVEL%
  echo %ID%: ABORTED. Firmware update NOT successful.
  echo %ID%: ABORTED. Firmware update NOT successful.  >> %LOGF%

:done

  echo %ID%: RETURN_STATUS=%RETURN_STATUS%
  echo %ID%: RETURN_STATUS=%RETURN_STATUS%  >>  %LOGF%
  echo %ID%: Ending at  >> %LOGF%
  date /t >> %LOGF%
  time /t >> %LOGF%
  echo %ID%: =====================================  >>  %LOGF%

  pause

  endlocal & set RETURN_STATUS=%RETURN_STATUS%
